package com.qys.ocr.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.qys.ocr.demo.test.QYSFileProviderUtils;
import com.qys.ocr.demo.test.QYSWebChromeClient;


public class MainActivity extends AppCompatActivity {

    private WebView mWebview;
    private QYSWebChromeClient qysWebChromeClient;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mWebview = (WebView) findViewById(R.id.webview);

        // 设置为App fileprovider的 authorities
        QYSFileProviderUtils.initAuthorityId(BuildConfig.APPLICATION_ID + ".qysdemo.fileprovider");

        mWebview.setWebViewClient(new WebViewClient());

        qysWebChromeClient = new QYSWebChromeClient(this,mWebview);
        mWebview.setWebChromeClient(qysWebChromeClient);

        mWebview.loadUrl(getIntent().getStringExtra("url"));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        qysWebChromeClient.onActivityResult(requestCode,resultCode,data);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        qysWebChromeClient.onRequestPermissionsResult(requestCode,permissions,grantResults);
    }
}
