package com.qys.ocr.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

public class UrlInputActivity extends AppCompatActivity {

    private EditText mEditText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_url_input);

        mEditText = (EditText) findViewById(R.id.edittext);

        findViewById(R.id.btn_confirm).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String url = mEditText.getText().toString().trim();
                if(TextUtils.isEmpty(url)){
                    Toast.makeText(UrlInputActivity.this,"输入url",Toast.LENGTH_SHORT).show();
                }else {
                    Intent intent = new Intent(UrlInputActivity.this, MainActivity.class);
                    intent.putExtra("url",url);
                    startActivity(intent);
                }
            }
        });

        findViewById(R.id.btn_clear).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mEditText.setText("");
            }
        });
    }
}