package com.qys.ocr.demo.test;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;

import java.io.File;

public class QYSFileProviderUtils {

    /**
     * FileProvider 指定Authrity,已在Manifest中配置
     */
    private static String sAuthority;

    // TODO 修改 sAuthority 为App Manifest中设置的FileProvider id
    public static void initAuthorityId(String authorityId){
        sAuthority = authorityId;
    }

    /**
     * 通过文件路径获取uri
     *
     * @param filePath
     * @return
     */
    public static Uri getUriForFile(String filePath, Context context) {
        return getUriForFile(new File(filePath),context);
    }

    /**
     * 获取文件uri
     *
     * @param file
     * @return
     */
    private static Uri getUriForFile(File file, Context context) {
        Uri fileUri = null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            fileUri = getUriForFile24(file,context);
        } else {
            fileUri = Uri.fromFile(file);
        }
        return fileUri;
    }

    /**
     * android 7.0 FileProvider获取uri方式
     *
     * @param file
     * @return
     */
    private static Uri getUriForFile24(File file, Context context) {
        Uri fileUri = FileProvider.getUriForFile(context, sAuthority, file);
        return fileUri;
    }
}
