package com.qys.ocr.demo.test;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

public class QYSWebChromeClient extends WebChromeClient {
    private final static int REQUEST_CODE_FILE_CHOOSER = 0xfe;
    private final static int REQUEST_CODE_CAMERA_WEBRTC = 0xfd;

    private Activity mActivity;
    private ValueCallback<Uri[]> filePathCallback;
    private FileChooserParams fileChooserParams;
    private QYSUploadHandler mUploadHandler;
    private PermissionRequest request;
    private WebView webView;

    public QYSWebChromeClient(Activity activity, WebView webView) {
        this.mActivity = activity;
        QYSH5FaceVerifySDK.getInstance().setWebViewSettings(webView, activity);
    }

    @Override
    public void onPermissionRequest(PermissionRequest request) {
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP) {
            if (request != null && request.getOrigin() != null && QYSH5FaceVerifySDK.getInstance().isQiyuesuoFaceVerify(request.getOrigin().toString())) {
                this.request = request;
                ActivityCompat.requestPermissions(mActivity, new String[]{
                                Manifest.permission.CAMERA,},
                        REQUEST_CODE_CAMERA_WEBRTC);
            }
        }
    }

    @Override
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
        this.webView = webView;
        boolean hasPermission = PackageManager.PERMISSION_GRANTED == ContextCompat.checkSelfPermission(mActivity, Manifest.permission.CAMERA)
                && PackageManager.PERMISSION_GRANTED == ContextCompat.checkSelfPermission(mActivity, Manifest.permission.WRITE_EXTERNAL_STORAGE);
        if (hasPermission) {
            if (QYSH5FaceVerifySDK.getInstance().recordVideoForApi21(webView, filePathCallback, mActivity, fileChooserParams)) {
                return true;
            }
            mUploadHandler = new QYSUploadHandler(mActivity, filePathCallback, fileChooserParams);
        } else {
            QYSWebChromeClient.this.filePathCallback = filePathCallback;
            QYSWebChromeClient.this.fileChooserParams = fileChooserParams;
            ActivityCompat.requestPermissions(mActivity, new String[]{
                            Manifest.permission.CAMERA,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE},
                    REQUEST_CODE_FILE_CHOOSER);
        }
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (QYSH5FaceVerifySDK.getInstance().receiveH5FaceVerifyResult(requestCode, resultCode, data))
            return;
        if (requestCode == QYSUploadHandler.FILE_SELECTED) {
            if (mUploadHandler != null) {
                mUploadHandler.onResult(resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == REQUEST_CODE_FILE_CHOOSER && grantResults.length > 0) {
            List<String> delayPermissionLists = new ArrayList<>();
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                    delayPermissionLists.add(permissions[i]);
                }
            }
            if (delayPermissionLists.isEmpty()) {
                if (QYSH5FaceVerifySDK.getInstance().recordVideoForApi21(webView, filePathCallback, mActivity, fileChooserParams)) {
                    return;
                }
                mUploadHandler = new QYSUploadHandler(mActivity, filePathCallback, fileChooserParams);
            } else {
                // TODO 根据自己实际业务需要处理
                Toast.makeText(mActivity, generateToastMessage(delayPermissionLists), Toast.LENGTH_SHORT).show();
                if (filePathCallback != null) {
                    filePathCallback.onReceiveValue(null);
                    filePathCallback = null;
                }
            }
        } else if (requestCode == REQUEST_CODE_CAMERA_WEBRTC) {
            if (grantResults.length > 0) {
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    enterTrtcFaceVerify();
                } else {
                    // TODO 根据自己实际业务需要处理
                    Toast.makeText(mActivity, "请去设置中开启相机权限", Toast.LENGTH_SHORT).show();
                }
            }
        }
    }

    public void enterTrtcFaceVerify() {
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP && request != null && request.getOrigin() != null) {
            if (QYSH5FaceVerifySDK.getInstance().isQiyuesuoFaceVerify(request.getOrigin().toString())) {
                request.grant(request.getResources());
                request.getOrigin();
            }
        }
    }

    private String generateToastMessage(List<String> delayPermissionLists) {
        if (delayPermissionLists.size() == 2) {
            return "请去设置中开启相机权限和存储权限";
        } else {
            return Manifest.permission.CAMERA.equals(delayPermissionLists.get(0))
                    ? "请去设置中开启相机权限"
                    : "请去设置中开启存储权限";
        }
    }
}
