/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.json;

import com.qiyuesuo.sdk.v2.exception.ServiceException;
import com.qiyuesuo.sdk.v2.json.JSONArray;
import com.qiyuesuo.sdk.v2.json.JSONObject;
import com.qiyuesuo.sdk.v2.response.SdkResponse;
import com.qiyuesuo.sdk.v2.utils.MapUtils;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static String toJson(Object object) {
        JSONObject jsonObject = new JSONObject(object);
        return jsonObject.toString();
    }

    public static String toJson(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public static String toJson(List<?> list) {
        JSONArray json = new JSONArray();
        for (Object object : list) {
            if (object instanceof Number || object instanceof String || object instanceof Enum || object instanceof Character) {
                json.put(object);
                continue;
            }
            if (object instanceof Map) {
                json.put((Map)object);
                continue;
            }
            JSONObject jsonObject = new JSONObject(object);
            json.put(jsonObject);
        }
        return json.toString();
    }

    public static Map<String, Object> toMap(Object object) {
        JSONObject jsonObject = new JSONObject(object);
        return jsonObject.toMap();
    }

    public static <T> SdkResponse toQysResponse(String json) {
        return JSONUtils.toQysResponse(json, null);
    }

    public static <T> SdkResponse<T> toQysResponse(String json, Class<T> targetClass) {
        JSONObject jsonObject = new JSONObject(json);
        Map<String, Object> map = jsonObject.toMap();
        Integer code = (Integer)map.get("code");
        String errorCode = (String)map.get("responseCode");
        String responseMessage = (String)map.get("responseMessage");
        String message = (String)map.get("message");
        Map resultMap = map.get("result") != null ? (Map)map.get("result") : null;
        try {
            Object result = targetClass == null || resultMap == null ? null : (Object)MapUtils.toObject(resultMap, targetClass);
            return new SdkResponse<Object>(code, errorCode, responseMessage, message, result);
        }
        catch (Exception e) {
            throw new ServiceException("\u89e3\u6790\u7ed3\u679c\u9519\u8bef", e);
        }
    }
}

