/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2;

import com.qiyuesuo.sdk.v2.exception.ServiceException;
import com.qiyuesuo.sdk.v2.http.HttpClient;
import com.qiyuesuo.sdk.v2.http.HttpHeader;
import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.utils.MD5;
import java.io.OutputStream;
import java.net.Proxy;
import java.util.UUID;

public class SdkClient {
    public static final String SDK_VERSION = "JAVA-3.9.8";
    private String accessKey;
    private String accessSecret;
    private String serverUrl;
    private int connectTimeout = 15000;
    private int readTimeout = 60000;
    private final Proxy proxy;
    private String language;

    public SdkClient(String serverUrl, String accessKey, String accessSecret) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.serverUrl = serverUrl;
        this.proxy = null;
    }

    public SdkClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public SdkClient(String serverUrl, String accessKey, String accessSecret, Proxy proxy) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.serverUrl = serverUrl;
        this.proxy = proxy;
    }

    public SdkClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout, Proxy proxy) {
        this(serverUrl, appKey, appSecret, proxy);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String service(SdkRequest request) throws ServiceException {
        String url = this.serverUrl.replaceAll("/+$", "") + request.getUrl();
        Long timestamp = System.currentTimeMillis();
        String nonce = UUID.randomUUID().toString();
        String signature = MD5.toMD5(this.accessKey + this.accessSecret + Long.toString(timestamp) + nonce);
        HttpHeader header = new HttpHeader(this.accessKey, timestamp, signature, SDK_VERSION, nonce).withLanguage(this.language);
        HttpParameter httpParameter = request.getHttpParameter();
        try {
            if (httpParameter.isJson()) {
                return HttpClient.doServiceWithJson(url, httpParameter.getJsonParams(), header, this.connectTimeout, this.readTimeout, this.proxy);
            }
            return HttpClient.doService(url, httpParameter, header, this.connectTimeout, this.readTimeout, this.proxy);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public void download(SdkRequest request, OutputStream outputStream) throws ServiceException {
        String url = this.serverUrl.replaceAll("/+$", "") + request.getUrl();
        Long timestamp = System.currentTimeMillis();
        String nonce = UUID.randomUUID().toString();
        String signature = MD5.toMD5(this.accessKey + this.accessSecret + Long.toString(timestamp) + nonce);
        HttpHeader header = new HttpHeader(this.accessKey, timestamp, signature, SDK_VERSION, nonce).withLanguage(this.language);
        try {
            HttpClient.doDownload(url, request.getHttpParameter(), header, this.connectTimeout, this.readTimeout, this.proxy, outputStream);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

