/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.http;

import com.qiyuesuo.sdk.v2.http.FileItem;
import com.qiyuesuo.sdk.v2.http.HttpConnection;
import com.qiyuesuo.sdk.v2.http.HttpHeader;
import com.qiyuesuo.sdk.v2.http.HttpMethod;
import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.utils.ArrayUtils;
import com.qiyuesuo.sdk.v2.utils.IOUtils;
import com.qiyuesuo.sdk.v2.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class HttpClient {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String CONTENT_FORM = "application/x-www-form-urlencoded;charset=UTF-8";
    public static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    public static final String CONTENT_MULTIPART = "multipart/form-data;charset=UTF-8; boundary=";
    public static final int RENNECT_TIMES = 2;

    public static String doService(String url, HttpParameter paramers, HttpHeader header, int connectTimeout, int readTimeout, Proxy proxy) throws Exception {
        HttpMethod httpMethod = paramers.getHttpMethod();
        switch (httpMethod) {
            case POST: {
                return HttpClient.doPost(url, paramers, header, connectTimeout, readTimeout, proxy);
            }
            case GET: {
                return HttpClient.doGet(url, paramers, header, connectTimeout, readTimeout, proxy);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doServiceWithJson(String url, String json, HttpHeader header, int connectTimeout, int readTimeout, Proxy proxy) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        byte[] content = null;
        try {
            conn = HttpConnection.getConnection(new URL(url), HttpMethod.POST, header, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            content = json == null ? ArrayUtils.EMPTY_BYTE_ARRAY : json.getBytes(DEFAULT_CHARSET);
            conn.setRequestProperty("Content-Type", APPLICATION_JSON);
            out = conn.getOutputStream();
        }
        catch (Exception e) {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
            throw e;
        }
        try {
            out.write(content);
            String string = HttpClient.getResponseAsString(conn);
            return string;
        }
        finally {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, HttpParameter paramers, HttpHeader header, int connectTimeout, int readTimeout, Proxy proxy) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String boundary = null;
        byte[] content = null;
        try {
            conn = HttpConnection.getConnection(new URL(url), HttpMethod.POST, header, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (paramers.isMultipart()) {
                boundary = "----sdkboundary" + StringUtils.random(6);
                conn.setRequestProperty("Content-Type", CONTENT_MULTIPART + boundary);
                out = conn.getOutputStream();
            } else {
                String query = paramers.getQueryString(DEFAULT_CHARSET);
                content = query == null ? ArrayUtils.EMPTY_BYTE_ARRAY : query.getBytes(DEFAULT_CHARSET);
                conn.setRequestProperty("Content-Type", CONTENT_FORM);
                out = conn.getOutputStream();
            }
        }
        catch (Exception e) {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
            throw e;
        }
        try {
            if (paramers.isMultipart()) {
                HttpClient.writeMutiContent(boundary, paramers, out);
            } else {
                out.write(content);
            }
            String string = HttpClient.getResponseAsString(conn);
            return string;
        }
        finally {
            IOUtils.safeClose(out);
            HttpConnection.close(conn);
        }
    }

    protected static void writeMutiContent(String boundary, HttpParameter paramers, OutputStream out) throws IOException {
        byte[] boundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(DEFAULT_CHARSET);
        Set<Map.Entry<String, String>> textEntrySet = paramers.getParams().entrySet();
        boolean firstParam = true;
        for (Map.Entry<String, String> textEntry : textEntrySet) {
            byte[] byArray = HttpClient.getTextEntry(textEntry.getKey(), textEntry.getValue(), DEFAULT_CHARSET);
            if (firstParam) {
                out.write(("--" + boundary + "\r\n").getBytes(DEFAULT_CHARSET));
                firstParam = false;
            } else {
                out.write(boundaryBytes);
            }
            out.write(byArray);
        }
        if (!paramers.getFiles().isEmpty()) {
            Set<Map.Entry<String, FileItem>> fileEntrySet = paramers.getFiles().entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                if (fileItem == null) continue;
                if (!fileItem.isValid()) {
                    throw new IOException("FileItem is invalid");
                }
                byte[] fileBytes = HttpClient.getFileEntry(entry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), DEFAULT_CHARSET);
                out.write(boundaryBytes);
                out.write(fileBytes);
                fileItem.write(out);
            }
        }
        if (!paramers.getListFiles().isEmpty()) {
            Set<Map.Entry<String, List<FileItem>>> listEntrySet = paramers.getListFiles().entrySet();
            for (Map.Entry<String, Object> entry : listEntrySet) {
                List items = (List)entry.getValue();
                for (FileItem item : items) {
                    if (!item.isValid()) {
                        throw new IOException("FileItem is invalid");
                    }
                    byte[] fileBytes = HttpClient.getFileEntry(entry.getKey(), item.getFileName(), item.getMimeType(), DEFAULT_CHARSET);
                    out.write(boundaryBytes);
                    out.write(fileBytes);
                    item.write(out);
                }
            }
        }
        byte[] endBoundary = ("\r\n--" + boundary + "--\r\n").getBytes(DEFAULT_CHARSET);
        out.write(endBoundary);
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, HttpParameter params, HttpHeader header, int connectTimeout, int readTimeout, Proxy proxy) throws Exception {
        HttpURLConnection conn = null;
        String query = params.getQueryString(DEFAULT_CHARSET);
        URL getUrl = HttpClient.buildGetUrl(url, query);
        int responseCode = 200;
        try {
            conn = HttpConnection.getConnection(getUrl, HttpMethod.GET, header, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            responseCode = conn.getResponseCode();
        }
        catch (Exception e) {
            HttpConnection.close(conn);
            throw e;
        }
        try {
            String string = HttpClient.getResponseAsString(conn, responseCode);
            return string;
        }
        finally {
            HttpConnection.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDownload(String url, HttpParameter params, HttpHeader header, int connectTimeout, int readTimeout, Proxy proxy, OutputStream outputStream) throws Exception {
        HttpURLConnection conn = null;
        String query = params.getQueryString(DEFAULT_CHARSET);
        URL getUrl = HttpClient.buildGetUrl(url, query);
        int responseCode = 200;
        for (int i = 0; i <= 2; ++i) {
            try {
                conn = HttpConnection.getConnection(getUrl, HttpMethod.GET, header, proxy);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                responseCode = conn.getResponseCode();
                break;
            }
            catch (Exception e) {
                HttpConnection.close(conn);
                if (i != 2) continue;
                throw e;
            }
        }
        try {
            HttpClient.getResponseAsOutputStream(conn, outputStream, responseCode);
        }
        catch (Throwable throwable) {
            HttpConnection.close(conn);
            throw throwable;
        }
        HttpConnection.close(conn);
    }

    protected static URL buildGetUrl(String url, String query) throws IOException {
        boolean hasPrepend;
        if (StringUtils.isEmpty(query)) {
            return new URL(url);
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean bl = hasPrepend = url.endsWith("?") || url.endsWith("&");
        if (!hasPrepend) {
            if (hasQuery) {
                newUrl.append("&");
            } else {
                newUrl.append("?");
                hasQuery = true;
            }
        }
        newUrl.append(query);
        hasPrepend = false;
        return new URL(newUrl.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseAsString(HttpURLConnection conn, int responseCode) throws IOException {
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        if (responseCode < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return HttpClient.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String errorStr = "";
        try (InputStream inputStream = conn.getErrorStream();){
            byte[] bs;
            if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                inputStream.read(bs);
                errorStr = new String(bs, DEFAULT_CHARSET);
            }
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpClient.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return HttpClient.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String errorStr = "";
        try (InputStream inputStream = conn.getErrorStream();){
            byte[] bs;
            if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                inputStream.read(bs);
                errorStr = new String(bs, DEFAULT_CHARSET);
            }
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getResponseAsOutputStream(HttpURLConnection conn, OutputStream outputStream, int responseCode) throws IOException {
        if (responseCode >= 400) {
            String errorStr = "";
            try (InputStream inputStream = conn.getErrorStream();){
                byte[] bs;
                if (inputStream != null && (bs = new byte[inputStream.available()]).length > 0) {
                    inputStream.read(bs);
                    errorStr = new String(bs, DEFAULT_CHARSET);
                }
            }
            throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage() + " " + errorStr);
        }
        outputStream.write(IOUtils.readStreamAsByteArray(conn.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }
}

