/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.http;

import com.qiyuesuo.sdk.v2.http.FileItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamFile
implements FileItem {
    private String fileName;
    private InputStream stream;
    private String mimeType;
    public static final String DEFAULT_FILE_NAME = "streamFile";

    public StreamFile(String fileName, InputStream stream, String mimeType) {
        this.fileName = fileName;
        this.stream = stream;
        this.mimeType = mimeType;
    }

    public StreamFile(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
        this.mimeType = "application/octet-stream";
    }

    public StreamFile(InputStream stream) {
        this.fileName = DEFAULT_FILE_NAME;
        this.stream = stream;
        this.mimeType = "application/octet-stream";
    }

    @Override
    public boolean isValid() {
        return this.stream != null && this.fileName != null;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    @Override
    public long getFileLength() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = this.stream.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }
}

