/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.utils;

import com.qiyuesuo.sdk.v2.utils.Algorithm;
import com.qiyuesuo.sdk.v2.utils.CryptUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private MessageDigest md5;
    private boolean init = false;

    private void init() {
        if (!this.init) {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
                this.init = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public MD5() {
        this.init();
    }

    public MD5(String inStr) {
        this.init();
        this.md5.update(inStr.getBytes());
    }

    public MD5(byte[] input) {
        this.init();
        this.md5.update(input);
    }

    public void update(byte[] input) {
        this.md5.update(input);
    }

    public String compute() {
        byte[] md5Bytes = this.md5.digest();
        StringBuffer hexValue = new StringBuffer();
        for (byte md5Byte : md5Bytes) {
            int val = md5Byte & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String toMD5(String plainText) {
        if (plainText == null) {
            return null;
        }
        try {
            byte[] data = plainText.getBytes("UTF-8");
            return MD5.md5String(data);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String md5String(byte[] data) {
        String md5Str = "";
        try {
            byte[] buf;
            MessageDigest md5 = MessageDigest.getInstance(Algorithm.MD5.getKey());
            for (byte element : buf = md5.digest(data)) {
                md5Str = md5Str + CryptUtils.byte2Hex(element);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return md5Str;
    }
}

