/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.common;

import com.qiyuesuo.sdk.v2.common.ParamBody;
import com.qiyuesuo.sdk.v2.exception.BaseSdkException;
import com.qiyuesuo.sdk.v2.http.FileItem;
import com.qiyuesuo.sdk.v2.http.HttpHeader;
import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.utils.CryptUtils;
import com.qiyuesuo.sdk.v2.utils.MD5;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSha256Signature {
    public static String compute(HttpParameter httpParameter, HttpHeader httpHeader, String secret, String url) throws IOException {
        ArrayList<ParamBody> paramBodyList = new ArrayList<ParamBody>();
        HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-accesstoken", httpHeader.getAccessToken());
        HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-agentaccesstoken", httpHeader.getAgentToken());
        HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-timestamp", String.valueOf(httpHeader.getTimestamp()));
        HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-nonce", httpHeader.getNonce());
        HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-signature-version", "HMACSHA256");
        if (httpParameter.isJson()) {
            String jsonStr = httpParameter.getJsonParams();
            HmacSha256Signature.addParamBody(paramBodyList, "x-qys-open-body", jsonStr);
        } else {
            Set<Map.Entry<String, String>> textEntrySet = httpParameter.getParams().entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                HmacSha256Signature.addParamBody(paramBodyList, entry.getKey(), entry.getValue());
            }
            Set<Map.Entry<String, FileItem>> fileEntrySet = httpParameter.getFiles().entrySet();
            for (Map.Entry<String, FileItem> entry : fileEntrySet) {
                FileItem fileItem = entry.getValue();
                if (fileItem == null) continue;
                String md5 = MD5.md5String(fileItem.cache());
                HmacSha256Signature.addParamBody(paramBodyList, entry.getKey(), md5);
            }
            Set<Map.Entry<String, List<FileItem>>> set = httpParameter.getListFiles().entrySet();
            for (Map.Entry<String, List<FileItem>> entry4 : set) {
                List<FileItem> tmpList = entry4.getValue();
                if (tmpList == null) continue;
                for (FileItem tmp : tmpList) {
                    if (tmp == null) continue;
                    String md5 = MD5.md5String(tmp.cache());
                    HmacSha256Signature.addParamBody(paramBodyList, entry4.getKey(), md5);
                }
            }
        }
        Collections.sort(paramBodyList, new Comparator<ParamBody>(){

            @Override
            public int compare(ParamBody p1, ParamBody p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMACSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HMACSHA256");
            mac.init(secretKey);
        }
        catch (Exception e) {
            throw new BaseSdkException("get mac error", e);
        }
        String method = httpParameter.getHttpMethod().name();
        mac.update(("requestMethod=" + method).getBytes(StandardCharsets.UTF_8));
        mac.update(("&requestUrl=" + url).getBytes(StandardCharsets.UTF_8));
        for (ParamBody paramBody : paramBodyList) {
            mac.update(('&' + paramBody.getName() + '=' + paramBody.getValue()).getBytes(StandardCharsets.UTF_8));
        }
        String string = CryptUtils.byte2Hex(mac.doFinal());
        return string;
    }

    private static void addParamBody(List<ParamBody> paramBodyList, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        name = name.trim();
        value = value.trim();
        if (name.length() == 0 || value.length() == 0) {
            return;
        }
        paramBodyList.add(new ParamBody(name, value));
    }
}

