/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.http;

import com.qiyuesuo.sdk.v2.http.HttpHeader;
import com.qiyuesuo.sdk.v2.http.HttpMethod;
import com.qiyuesuo.sdk.v2.http.TrustAllTrustManager;
import com.qiyuesuo.sdk.v2.utils.StringUtils;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class HttpConnection {
    private static boolean ignoreSSLCheck = false;
    private static HostnameVerifier hostnameVerifier = new TrustAllHostnameVerifier();

    public static HttpURLConnection getConnection(URL url, HttpMethod method, HttpHeader header, Proxy proxy) throws Exception {
        HttpURLConnection conn;
        HttpURLConnection httpURLConnection = conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
            httpsConnection.setHostnameVerifier(hostnameVerifier);
            if (ignoreSSLCheck) {
                SSLSocketFactory sslSocketFactory = TrustAllTrustManager.getSSLSocketFactory();
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
            }
            conn = httpsConnection;
        }
        conn.setRequestMethod(method.name());
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Host", url.getHost());
        conn.setRequestProperty("Accept", "text/plain,application/json");
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setRequestProperty("User-Agent", "qiyuesuo-java-sdk");
        if (header.getTimestamp() != null) {
            conn.setRequestProperty("x-qys-open-timestamp", Long.toString(header.getTimestamp()));
        }
        if (StringUtils.isNotBlank(header.getSignature())) {
            conn.setRequestProperty("x-qys-open-signature", header.getSignature());
        }
        if (StringUtils.isNotBlank(header.getAccessToken())) {
            conn.setRequestProperty("x-qys-open-accesstoken", header.getAccessToken());
        }
        if (StringUtils.isNotBlank(header.getAgentToken())) {
            conn.setRequestProperty("x-qys-open-agentaccesstoken", header.getAgentToken());
        }
        if (StringUtils.isNotBlank(header.getAgentSignature())) {
            conn.setRequestProperty("x-qys-open-agentsignature", header.getAgentSignature());
        }
        if (StringUtils.isNotBlank(header.getNonce())) {
            conn.setRequestProperty("x-qys-open-nonce", header.getNonce());
        }
        if (StringUtils.isNoneBlank(header.getVersion())) {
            conn.setRequestProperty("version", header.getVersion());
        }
        if (StringUtils.isNoneBlank(header.getLanguage())) {
            conn.setRequestProperty("x-qys-open-language", header.getLanguage());
        }
        if (StringUtils.isNoneBlank(header.getSignatureVersion())) {
            conn.setRequestProperty("x-qys-open-signature-version", header.getSignatureVersion());
        }
        return conn;
    }

    public static void close(HttpURLConnection conn) {
        if (conn != null) {
            conn.disconnect();
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

