/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.utils;

import com.qiyuesuo.sdk.v2.utils.TimeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MapUtils {
    private static Class[] BASIC_TYPES = new Class[]{String.class, Long.class, Integer.class, Float.class, Double.class, Boolean.class, Date.class};

    public static <T> T toObject(Map<String, Object> map, Class<T> beanClass) throws Exception {
        T bean = null;
        try {
            bean = beanClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map == null || map.isEmpty()) {
            return bean;
        }
        for (String methodName : map.keySet()) {
            Field[] fields;
            Object value = map.get(methodName);
            if (value == null) continue;
            Field beanField = null;
            for (Field field : fields = beanClass.getDeclaredFields()) {
                if (!field.getName().equals(methodName)) continue;
                beanField = field;
                break;
            }
            if (beanField == null) continue;
            value = MapUtils.convertValue(beanField, value);
            String methodName1 = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
            Method method = beanClass.getMethod(methodName1, beanField.getType());
            method.invoke(bean, value);
        }
        return bean;
    }

    private static Object convertValue(Field beanField, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (MapUtils.isBasicTypes(beanField.getType())) {
            value = MapUtils.convertBasicValue(beanField.getType(), value);
        } else if (beanField.getType().isAssignableFrom(List.class)) {
            ParameterizedType pt = (ParameterizedType)beanField.getGenericType();
            Class listClass = (Class)pt.getActualTypeArguments()[0];
            if (!MapUtils.isBasicTypes(listClass)) {
                ArrayList objects = new ArrayList();
                if (value != null) {
                    List maps = value;
                    for (Map tempMap : maps) {
                        Object object = MapUtils.toObject(tempMap, listClass);
                        objects.add(object);
                    }
                }
                value = objects;
            } else if (!listClass.equals(String.class)) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List valList = value;
                for (Object obj : valList) {
                    Object object = MapUtils.convertBasicValue(listClass, obj);
                    objects.add(object);
                }
                value = objects;
            }
        } else {
            Class<?> tempClass = beanField.getType();
            Map tempMap = (Map)((Object)value);
            value = MapUtils.toObject(tempMap, tempClass);
        }
        return value;
    }

    private static Object convertBasicValue(Class c, Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        if (c.isAssignableFrom(String.class)) {
            value = value.toString();
        } else if (c.isAssignableFrom(Long.class)) {
            value = Long.parseLong(value.toString());
        } else if (c.isAssignableFrom(Integer.class)) {
            value = Integer.parseInt(value.toString());
        } else if (c.isAssignableFrom(Float.class)) {
            value = Float.valueOf(Float.parseFloat(value.toString()));
        } else if (c.isAssignableFrom(Double.class)) {
            value = Double.parseDouble(value.toString());
        } else if (c.isAssignableFrom(Boolean.class)) {
            value = Boolean.parseBoolean(value.toString());
        } else if (c.isAssignableFrom(Date.class)) {
            value = TimeUtils.parse(value.toString());
        } else if (c.isEnum()) {
            String methodType = c.getName();
            value = MapUtils.convertToEnum(methodType, value);
        }
        return value;
    }

    private static boolean isBasicTypes(Class c) {
        for (Class item : BASIC_TYPES) {
            if (!c.isAssignableFrom(item)) continue;
            return true;
        }
        return c.isEnum();
    }

    private static Enum convertToEnum(String enumName, Object value) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(enumName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return myE;
        }
        return Enum.valueOf(clazz, value.toString());
    }

    public static <T> List<T> toObjectList(List<Map<String, Object>> maps, Class<T> beanClass) throws Exception {
        if (maps == null || maps.size() < 0) {
            return null;
        }
        ArrayList<T> beanList = new ArrayList<T>();
        for (Map<String, Object> tempMap : maps) {
            T bean = MapUtils.toObject(tempMap, beanClass);
            beanList.add(bean);
        }
        return beanList;
    }
}

